/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.gantry;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionCollider;
import com.simibubi.create.content.contraptions.components.structureMovement.IDisplayAssemblyExceptions;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryCarriageBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryContraptionEntity;
import com.simibubi.create.content.contraptions.relays.advanced.GantryShaftBlock;
import com.simibubi.create.content.contraptions.relays.advanced.GantryShaftTileEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class GantryCarriageTileEntity
extends KineticTileEntity
implements IDisplayAssemblyExceptions {
    boolean assembleNextTick;
    protected AssemblyException lastException;

    public GantryCarriageTileEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.registerAwardables(behaviours, AllAdvancements.CONTRAPTION_ACTORS);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
    }

    public void checkValidGantryShaft() {
        if (this.shouldAssemble()) {
            this.queueAssembly();
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.m_58900_().m_60710_((LevelReader)this.f_58857_, this.f_58858_)) {
            this.f_58857_.m_46961_(this.f_58858_, true);
        }
    }

    public void queueAssembly() {
        this.assembleNextTick = true;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.assembleNextTick) {
            this.tryAssemble();
            this.assembleNextTick = false;
        }
    }

    @Override
    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    private void tryAssemble() {
        Direction shaftOrientation;
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof GantryCarriageBlock)) {
            return;
        }
        Direction direction = (Direction)blockState.m_61143_((Property)GantryCarriageBlock.FACING);
        GantryContraption contraption = new GantryContraption(direction);
        BlockEntity shaftTe = this.f_58857_.m_7702_(this.f_58858_.m_142300_(direction.m_122424_()));
        if (!(shaftTe instanceof GantryShaftTileEntity)) {
            return;
        }
        BlockState shaftState = shaftTe.m_58900_();
        if (!AllBlocks.GANTRY_SHAFT.has(shaftState)) {
            return;
        }
        float pinionMovementSpeed = ((GantryShaftTileEntity)shaftTe).getPinionMovementSpeed();
        Direction movementDirection = shaftOrientation = (Direction)shaftState.m_61143_((Property)GantryShaftBlock.FACING);
        if (pinionMovementSpeed < 0.0f) {
            movementDirection = movementDirection.m_122424_();
        }
        try {
            this.lastException = null;
            if (!contraption.assemble(this.f_58857_, this.f_58858_)) {
                return;
            }
            this.sendData();
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return;
        }
        if (ContraptionCollider.isCollidingWithWorld(this.f_58857_, contraption, this.f_58858_.m_142300_(movementDirection), movementDirection)) {
            return;
        }
        if (contraption.containsBlockBreakers()) {
            this.award(AllAdvancements.CONTRAPTION_ACTORS);
        }
        contraption.removeBlocksFromWorld(this.f_58857_, BlockPos.f_121853_);
        GantryContraptionEntity movedContraption = GantryContraptionEntity.create(this.f_58857_, contraption, shaftOrientation);
        BlockPos anchor = this.f_58858_;
        movedContraption.m_6034_(anchor.m_123341_(), anchor.m_123342_(), anchor.m_123343_());
        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.f_58857_, (Vec3i)this.f_58858_);
        this.f_58857_.m_7967_((Entity)movedContraption);
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        AssemblyException.write(compound, this.lastException);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        this.lastException = AssemblyException.read(compound);
        super.read(compound, clientPacket);
    }

    @Override
    public float propagateRotationTo(KineticTileEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        float defaultModifier = super.propagateRotationTo(target, stateFrom, stateTo, diff, connectedViaAxes, connectedViaCogs);
        if (connectedViaAxes) {
            return defaultModifier;
        }
        if (!AllBlocks.GANTRY_SHAFT.has(stateTo)) {
            return defaultModifier;
        }
        if (!((Boolean)stateTo.m_61143_((Property)GantryShaftBlock.POWERED)).booleanValue()) {
            return defaultModifier;
        }
        Direction direction = Direction.m_122372_((float)diff.m_123341_(), (float)diff.m_123342_(), (float)diff.m_123343_());
        if (stateFrom.m_61143_((Property)GantryCarriageBlock.FACING) != direction.m_122424_()) {
            return defaultModifier;
        }
        return GantryCarriageTileEntity.getGantryPinionModifier((Direction)stateTo.m_61143_((Property)GantryShaftBlock.FACING), (Direction)stateFrom.m_61143_((Property)GantryCarriageBlock.FACING));
    }

    public static float getGantryPinionModifier(Direction shaft, Direction pinionDirection) {
        Direction.Axis shaftAxis = shaft.m_122434_();
        float directionModifier = shaft.m_122421_().m_122540_();
        if (shaftAxis == Direction.Axis.Y && (pinionDirection == Direction.NORTH || pinionDirection == Direction.EAST)) {
            return -directionModifier;
        }
        if (shaftAxis == Direction.Axis.X && (pinionDirection == Direction.DOWN || pinionDirection == Direction.SOUTH)) {
            return -directionModifier;
        }
        if (shaftAxis == Direction.Axis.Z && (pinionDirection == Direction.UP || pinionDirection == Direction.WEST)) {
            return -directionModifier;
        }
        return directionModifier;
    }

    private boolean shouldAssemble() {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof GantryCarriageBlock)) {
            return false;
        }
        Direction facing = ((Direction)blockState.m_61143_((Property)GantryCarriageBlock.FACING)).m_122424_();
        BlockState shaftState = this.f_58857_.m_8055_(this.f_58858_.m_142300_(facing));
        if (!(shaftState.m_60734_() instanceof GantryShaftBlock)) {
            return false;
        }
        if (((Boolean)shaftState.m_61143_((Property)GantryShaftBlock.POWERED)).booleanValue()) {
            return false;
        }
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_142300_(facing));
        return te instanceof GantryShaftTileEntity && ((GantryShaftTileEntity)te).canAssembleOn();
    }
}

